# M5Core2 Library

[![Arduino Compile](https://github.com/m5stack/M5Core2/actions/workflows/arduino-action-compile.yml/badge.svg)](https://github.com/m5stack/M5Core2/actions/workflows/arduino-action-compile.yml)
[![Arduino Lint](https://github.com/m5stack/M5Core2/actions/workflows/Arduino-Lint-Check.yml/badge.svg)](https://github.com/m5stack/M5Core2/actions/workflows/Arduino-Lint-Check.yml)
[![Clang Format](https://github.com/m5stack/M5Core2/actions/workflows/clang-format-check.yml/badge.svg)](https://github.com/m5stack/M5Core2/actions/workflows/clang-format-check.yml)

English | [中文](README_cn.md)

<img src="https://static-cdn.m5stack.com/resource/docs/products/core/core2/core2_01.webp" alt="M5Core2_P1" width="350" height="350">

**For the Detailed documentation of M5Core2, Please [Click here](https://docs.m5stack.com/en/core/core2)**

**In order to buy  M5Core2, Please [Click here](https://shop.m5stack.com/collections/m5-controllers/products/m5stack-core2-esp32-iot-development-kit)**

## Description

**M5Core2** is the second generation core device in the M5Stack development kit series, which further enhances the functions of the original generation of cores. 

The MCU is an ESP32 model D0WDQ6-V3 and has dual core Xtensa® 32-bit 240Mhz LX6 processors that can be controlled separately. WiFi and Bluetooth are supported as standard and it includes an on board 16MB Flash and 8MB PSRAM, USB TYPE-C interface for charging, downloading of programs and serial communication, a 2.0-inch integrated capacitive touch screen, and a built-in vibration motor. 

M5Core2 also features a built-in RTC module which can provide accurate timing. The power supply is managed by an AXP192 power management chip, which can effectively control the power consumption of the base and a built-in green LED power indicator helps to notify the user of battery level. The battery capacity has been upgraded to 390mAh, which can power the core for much longer than the previous model. 

The M5Core2 retains the SD card slot and speakers. However, in order to ensure higher quality sound output, the I2S digital audio interface power amplifier chip is used to effectively prevent signal distortion. There are independent power and reset buttons on the left side and bottom of the base. 

The 3 icons on the front of the screen are capacitive buttons which are programmable. There is a small expansion board on the back of the base with a 6-axis IMU sensor and microphone.

## M5Core2 M-BUS Schematic diagram

<img src="https://static-cdn.m5stack.com/resource/docs/products/core/core2/core2_mbus_01.webp" width = "50%">

## More Information

**UIFlow Quick Start**: [Click Here](https://docs.m5stack.com/en/quick_start/core2/uiflow)

**MicroPython API**: [Click Here](https://docs.m5stack.com/en/quick_start/core2/mpy)

**Arduino IDE Development**: [Click Here](https://docs.m5stack.com/en/quick_start/core2/arduino)

**M5Core2 Arduino API**: [Click Here](https://docs.m5stack.com/en/api/core2/axp192_core2)

**PinMap**: [Click Here](https://docs.m5stack.com/en/core/core2)
